<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:strip-space elements="*"/>
	<xsl:output method="html" indent="yes" encoding="utf-8"/>
	
	<xsl:template match="IMAGES-UPLOAD">
	</xsl:template>
	
	<xsl:template match="IMAGES-UPLOAD" mode="content">
		<script src='/modules/ImageGallery/js/uploadManager.js?{$version}.{$build}' type='text/javascript'/>
		
		<table border="0" style="width:100%;">
			<!-- draw select box for resize images -->
			<tr>
				<td style="width:50%;" align="left">
					<xsl:call-template name="LABEL" mode="label">
						<xsl:with-param name="title" select="/SITEBUILDER-PAGE/LOCALE/IMAGE-UPLOAD-RESIZE"/>
					</xsl:call-template>
					&#160;
					<select name="resizeImages">
						<xsl:apply-templates select="IMAGE-SELECT-ITEM-RESIZE"/>
						<option value="0">
							<xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/IMAGE-UPLOAD-NO_RESIZE"/>
						</option>
					</select>
				</td>
				<td style="width:10%;" align="left"></td>
				<td style="width:40%;" align="left">					
					<table cellpadding="0" cellspacing="0" border="0" class="control-input-title">
						<tr>
							<td class="input-block">
								<xsl:call-template name="CHECKBOX" mode="control">
									<xsl:with-param name="checked">true</xsl:with-param>
									<xsl:with-param name="id">defaultImageName</xsl:with-param>
									<xsl:with-param name="name">defaultImageName</xsl:with-param>
								</xsl:call-template>
							</td>
							<td class="title-block">
								<xsl:call-template name="LABEL" mode="label">
									<xsl:with-param name="id">defaultImageName</xsl:with-param>
									<xsl:with-param name="title" select="/SITEBUILDER-PAGE/LOCALE/IMAGE-UPLOAD-DEFAULT"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
			</tr>
			<!-- draw padding top 10px between select box and list items for upload images -->
			<tr>
				<td colspan="3" style="padding-top:10px;">
					<div style="width:100%; height:0px;"><span></span></div>
				</td>
			</tr>
			<tr>
				<td colspan="3" width="100%">
					<div style="overflow:auto; width:100%;height:180px;">
						<table cellpadding="0" cellspacing="0" border="0" width="100%" id="uploadManager">
							<!-- draw list items for upload images -->
							<xsl:apply-templates select="IMAGE-UPLOAD-ITEM"/>
						</table>
					</div>
				</td>
			</tr>
			
		</table>
		
		<!-- draw button upload -->
		<table border="0" style="width:100%;">
			<tr style="display:none" id="defaultUploadImage">
				<td style="padding-left: 0px; padding-bottom: 5px; width:300px;" align="left">
					<xsl:call-template name="LABEL" mode="label">
						<xsl:with-param name="title" select="/SITEBUILDER-PAGE/LOCALE/IMAGE-FILE"/>
					</xsl:call-template>
					&#160;
					<xsl:call-template name="INPUT" mode="control">
						<xsl:with-param name="name">imagesFile[]</xsl:with-param>
						<xsl:with-param name="onchange">checkBrowse();</xsl:with-param>
						<xsl:with-param name="style">display:none;</xsl:with-param>
						<xsl:with-param name="type">file</xsl:with-param>
					</xsl:call-template>
				</td>
				<td style="width:10%">
				</td>
				<td style="padding-left: 0px; padding-bottom: 5px; width:40%;" align="left">
					<xsl:call-template name="LABEL" mode="label">
						<xsl:with-param name="title" select="/SITEBUILDER-PAGE/LOCALE/IMAGE-UPLOAD-TITLE"/>
					</xsl:call-template>
					&#160;
					<xsl:call-template name="INPUT" mode="control">
						<xsl:with-param name="name">imagesTitle[]</xsl:with-param>
						<xsl:with-param name="maxlength">50</xsl:with-param>
					</xsl:call-template>
				</td>
			</tr>
		</table>
		<br/>
		<!--<xsl:call-template name="MODULE-MODAL-FORM-OK-CANCEL-BUTTONS"/>-->
		<xsl:call-template name="OK-CANCEL-BUTTONS">
			<xsl:with-param name="okAction">uploadImages();</xsl:with-param>
			<xsl:with-param name="cancelAction">document.location.href='<xsl:value-of select="/SITEBUILDER-PAGE/APPLY-CHANGES/@VIEW-URL"/>';</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template match="IMAGES-UPLOAD" mode="initAfterBody">
		<xsl:call-template name="MODAL-FORM">
			<xsl:with-param name="formName">modalForm</xsl:with-param>
			<xsl:with-param name="formTitle" select="/SITEBUILDER-PAGE/LOCALE/FORM-TITLE"/>
			<!--<xsl:with-param name="helpHint" select="/SITEBUILDER-PAGE/LOCALE/HELP-HINT"/>-->
			<!--<xsl:with-param name="closeHint" select="@CLOSE-HINT"/>-->
			<xsl:with-param name="additionalFormStyle">width: 800px; height: 360px;</xsl:with-param>
			<xsl:with-param name="content" select="current()" />
			<xsl:with-param name="onCloseAction">sbNavigationObject.go();</xsl:with-param>
		</xsl:call-template>	
	</xsl:template>
	
	
	<xsl:template match="IMAGES-UPLOAD-CARD">
	</xsl:template>
	
	<xsl:template match="IMAGE-SELECT-ITEM-RESIZE">
		<option>
			<xsl:attribute name="value"><xsl:value-of select="@CODE"/></xsl:attribute>
			<xsl:if test="@SELECTED=1">
				<xsl:attribute name="selected">true</xsl:attribute>
			</xsl:if>
			<xsl:value-of select="@SIZE"/>
		</option>
	</xsl:template>

	<xsl:template match="IMAGE-UPLOAD-ITEM">
		<tr>
			<td style="padding-left: 0px; padding-bottom: 5px; padding-top: 5px; width:300px" align="left">
				<xsl:call-template name="LABEL" mode="label">
					<xsl:with-param name="title" select="/SITEBUILDER-PAGE/LOCALE/IMAGE-FILE"/>
				</xsl:call-template>
					&#160;
				<xsl:call-template name="INPUT" mode="control">
					<xsl:with-param name="name">imagesFile[]</xsl:with-param>
					<xsl:with-param name="onchange">checkBrowse();</xsl:with-param>
					<xsl:with-param name="type">file</xsl:with-param>
				</xsl:call-template>
			</td>
			<td style="width:5%"></td>
			<td style="padding-left: 0px; padding-bottom: 5px; width:40%;" align="left">
					<xsl:call-template name="LABEL" mode="label">
						<xsl:with-param name="title" select="/SITEBUILDER-PAGE/LOCALE/IMAGE-UPLOAD-TITLE"/>
					</xsl:call-template>	
					&#160;
					<xsl:call-template name="INPUT" mode="control">
						<xsl:with-param name="name">imagesTitle[]</xsl:with-param>
						<xsl:with-param name="maxlength">50</xsl:with-param>
					</xsl:call-template>
			</td>
		</tr>
	</xsl:template>
</xsl:stylesheet>