<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:strip-space elements="*"/>
	<xsl:output method="html" indent="yes" encoding="utf-8"/>
	
	<xsl:template match="NOTIFICATION-SETTINGS">
		<script language="javascript">
			var selectedIssueId = '<xsl:value-of select="COMMON-ISSUE/@NAME"/>'; 
		
			function selectIssue(id) {
				document.getElementById(selectedIssueId).style.display = 'none';
				document.getElementById(id).style.display = 'block';
				if (id != '<xsl:value-of select="COMMON-ISSUE/@NAME"/>') {
					eval('Init_Wysiwyg_'+id+'()');
				}
				selectedIssueId = id;
			}
		</script>
		
		<table cellpadding="0" cellspacing="0" border="0" class="control-title-input">
			<tr>
				<td class="title-block">
					<xsl:call-template name="LABEL" mode="label">
						<xsl:with-param name="id">issue</xsl:with-param>
						<xsl:with-param name="title" select="/SITEBUILDER-PAGE/LOCALE/SELECT-ISSUE"/>
					</xsl:call-template>
				</td>
				<td class="input-block">
					<select id="issue" name="issue" onchange="selectIssue(this.value);">
						<option>
							<xsl:attribute name="value"><xsl:value-of select="COMMON-ISSUE/@NAME"/></xsl:attribute>
							<xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/COMMON-ISSUE"/>
						</option>
						<option>
							<xsl:attribute name="value"><xsl:value-of select="SIGNUP-ISSUE/@NAME"/></xsl:attribute>
							<xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/SIGN-UP-ISSUE"/>
						</option>
						<option>
							<xsl:attribute name="value"><xsl:value-of select="FORGET-PASSWORD-ISSUE/@NAME"/></xsl:attribute>
							<xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/FORGET-PASSWORD-ISSUE"/>
						</option>
					</select>
				</td>
			</tr>
		</table>
		
		<div>
			<xsl:attribute name="id"><xsl:value-of select="COMMON-ISSUE/@NAME"/></xsl:attribute>
			<xsl:apply-templates select="COMMON-ISSUE"/>
		</div>
		<div style="display: none;">
			<xsl:attribute name="id"><xsl:value-of select="SIGNUP-ISSUE/@NAME"/></xsl:attribute>
			<xsl:apply-templates select="SIGNUP-ISSUE"/>
		</div>
		<div style="display: none;">
			<xsl:attribute name="id"><xsl:value-of select="FORGET-PASSWORD-ISSUE/@NAME"/></xsl:attribute>
			<xsl:apply-templates select="FORGET-PASSWORD-ISSUE"/>
		</div>
	</xsl:template>
	
	<xsl:template match="COMMON-ISSUE">
		<table cellpadding="0" cellspacing="0" border="0" class="control-title-input">			
			<tr>				
				<td class="title-block">
					<xsl:call-template name="LABEL" mode="label">
						<xsl:with-param name="id">fromEmail</xsl:with-param>
						<xsl:with-param name="title" select="/SITEBUILDER-PAGE/LOCALE/FROM-EMAIL"/>
					</xsl:call-template>
				</td>
				<td class="input-block">
					<xsl:call-template name="INPUT" mode="control">
						<xsl:with-param name="id">fromEmail</xsl:with-param>
						<xsl:with-param name="name">fromEmail</xsl:with-param>
						<xsl:with-param name="onchange">self.sbApplyChangesObject.registerChange();</xsl:with-param>
						<xsl:with-param name="size">60</xsl:with-param>
						<xsl:with-param name="value" select="@FROM-EMAIL"/>
					</xsl:call-template>
				</td>
			</tr>	
		</table>
	</xsl:template>
	
	<xsl:template match="SIGNUP-ISSUE">
		<table cellpadding="0" cellspacing="0" border="0" class="control-title-input">			
			<tr>				
				<td class="title-block">
					<xsl:call-template name="LABEL" mode="label">
						<xsl:with-param name="id" select="@NAME"/>
						<xsl:with-param name="title" select="/SITEBUILDER-PAGE/LOCALE/SIGN-UP-EMAIL-SUBJECT"/>
					</xsl:call-template>
				</td>
				<td class="input-block">
					<xsl:call-template name="INPUT" mode="control">
						<xsl:with-param name="id" select="@NAME"/>
						<xsl:with-param name="name" select="@NAME"/>
						<xsl:with-param name="onchange">self.sbApplyChangesObject.registerChange();</xsl:with-param>
						<xsl:with-param name="size">60</xsl:with-param>
						<xsl:with-param name="value" select="@SUBJECT"/>
					</xsl:call-template>
				</td>
			</tr>	
		</table>
		
		<div style="width: 0; height: 5px;"><span></span></div>
		
		<xsl:call-template name="LABEL" mode="label">
			<xsl:with-param name="title" select="/SITEBUILDER-PAGE/LOCALE/SIGN-UP-EMAIL-MESSAGE"/>
		</xsl:call-template><br/>
		<xsl:apply-templates select="WYSIWYG">
			<xsl:with-param name="id"><xsl:value-of select="@NAME"/></xsl:with-param>
		</xsl:apply-templates>
	</xsl:template>

	<xsl:template match="FORGET-PASSWORD-ISSUE">
		<table cellpadding="0" cellspacing="0" border="0" class="control-title-input">			
			<tr>				
				<td class="title-block">
					<xsl:call-template name="LABEL" mode="label">
						<xsl:with-param name="id" select="@NAME"/>
						<xsl:with-param name="title" select="/SITEBUILDER-PAGE/LOCALE/FORGET-PASSWORD-EMAIL-SUBJECT"/>
					</xsl:call-template>
				</td>
				<td class="input-block">
					<xsl:call-template name="INPUT" mode="control">
						<xsl:with-param name="id" select="@NAME"/>
						<xsl:with-param name="name" select="@NAME"/>
						<xsl:with-param name="onchange">self.sbApplyChangesObject.registerChange();</xsl:with-param>
						<xsl:with-param name="value" select="@SUBJECT"/>
					</xsl:call-template>
				</td>
			</tr>	
		</table>
		
		<div style="width: 0; height: 5px;"><span></span></div>
		
		<xsl:call-template name="LABEL" mode="label">
			<xsl:with-param name="title" select="/SITEBUILDER-PAGE/LOCALE/FORGET-PASSWORD-EMAIL-MESSAGE"/>
		</xsl:call-template><br/>
		<xsl:apply-templates select="WYSIWYG">
			<xsl:with-param name="id"><xsl:value-of select="@NAME"/></xsl:with-param>
		</xsl:apply-templates>
	</xsl:template>

	<xsl:template match="WYSIWYG[@MODE='emailNotification']">
		<xsl:param name="id" />
		
		<xsl:call-template name="WYSIWYG-MODULE">
			<xsl:with-param name="Wysiwyg">
				<xsl:text>Wysiwyg_</xsl:text><xsl:value-of select="$id"/>
			</xsl:with-param>
			<xsl:with-param name="config">LoginNotification.js</xsl:with-param>
		</xsl:call-template>
	</xsl:template>	
	
	</xsl:stylesheet>	