<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:strip-space elements="*"/>
	<xsl:output method="html" indent="yes" encoding="utf-8"/>

	<xsl:template name="SITE-USER-FIELDS">
		<script type="text/javascript" src="/modules/Login/js/validate.js?{$version}.{$build}"/>
	
		<input type="hidden" id="userId" name="userId" >
			<xsl:attribute name="value"><xsl:value-of select="@USER-ID"/></xsl:attribute>
		</input>

		<fieldset>
			<legend><xsl:value-of select="@LOGIN-TITLE"/></legend>
			<div class="fieldset-block">
				<table cellpadding="0" cellspacing="0" border="0" class="control-title-input">
					<xsl:call-template name="SITE-USER-FORM-ROW">
						<xsl:with-param name="name">name</xsl:with-param>
						<xsl:with-param name="require">true</xsl:with-param>
					</xsl:call-template>
					<xsl:call-template name="SITE-USER-FORM-ROW">
						<xsl:with-param name="name">email</xsl:with-param>
						<xsl:with-param name="size">60</xsl:with-param>
						<xsl:with-param name="require">true</xsl:with-param>
					</xsl:call-template>
					<xsl:call-template name="PASSWORD-FORM"/>
				</table>
			</div>
		</fieldset>

		<fieldset>
			<legend><xsl:value-of select="@MAIN-TITLE"/></legend>
			<div class="fieldset-block">
				<table cellpadding="0" cellspacing="0" border="0" class="control-title-input">
					<xsl:call-template name="SITE-USER-FORM-ROW">
						<xsl:with-param name="name">firstName</xsl:with-param>
					</xsl:call-template>
					<xsl:call-template name="SITE-USER-FORM-ROW">
						<xsl:with-param name="name">lastName</xsl:with-param>
					</xsl:call-template>
					<xsl:call-template name="SITE-USER-FORM-ROW">
						<xsl:with-param name="name">company</xsl:with-param>
					</xsl:call-template>
					<xsl:call-template name="SITE-USER-FORM-ROW">
						<xsl:with-param name="name">phoneNumber</xsl:with-param>
					</xsl:call-template>
					<xsl:call-template name="SITE-USER-FORM-ROW">
						<xsl:with-param name="name">address1</xsl:with-param>
						<xsl:with-param name="size">60</xsl:with-param>
					</xsl:call-template>
					<xsl:call-template name="SITE-USER-FORM-ROW">
						<xsl:with-param name="name">address2</xsl:with-param>
						<xsl:with-param name="size">60</xsl:with-param>
					</xsl:call-template>
					<xsl:call-template name="SITE-USER-FORM-ROW">
						<xsl:with-param name="name">city</xsl:with-param>
					</xsl:call-template>
					<xsl:call-template name="SITE-USER-FORM-ROW">
						<xsl:with-param name="name">state</xsl:with-param>
					</xsl:call-template>
					<xsl:call-template name="SITE-USER-FORM-ROW">
						<xsl:with-param name="name">country</xsl:with-param>
					</xsl:call-template>
					<xsl:call-template name="SITE-USER-FORM-ROW">
						<xsl:with-param name="name">zip</xsl:with-param>
					</xsl:call-template>
				</table>
			</div>
		</fieldset>
		
		<div class="form-separator"><span></span></div>
		
		<xsl:call-template name="OK-CANCEL-BUTTONS">
			<xsl:with-param name="okAction">if (validateSiteUser()) { wizardFormSubmit(); }</xsl:with-param>
			<xsl:with-param name="cancelAction">document.location.href='<xsl:value-of select="/SITEBUILDER-PAGE/APPLY-CHANGES/@VIEW-URL"/>';</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

	<xsl:template match="OBJECT[@TYPE='SITE-USER']">
	</xsl:template>
	
	<xsl:template match="OBJECT[@TYPE='SITE-USER']" mode="initAfterBody">
		<xsl:call-template name="MODAL-FORM">
			<xsl:with-param name="formName">modalForm</xsl:with-param>
			<xsl:with-param name="formTitle" select="/SITEBUILDER-PAGE/LOCALE/FORM-TITLE"/>
			<xsl:with-param name="additionalFormStyle">width: 650px; height: 600px;</xsl:with-param>
			<xsl:with-param name="content" select="current()" />
			<xsl:with-param name="onCloseAction">sbNavigationObject.go();</xsl:with-param>
		</xsl:call-template>
		
	</xsl:template>	
	
	<xsl:template name="SITE-USER-FORM-ROW">
		<!--alphabet order-->
		<xsl:param name="name"/>
		<xsl:param name="require"/>
		
		<tr>
			<td class="title-block">
				<xsl:apply-templates select="CONTROL[@NAME=$name]" mode="label">
					<xsl:with-param name="require" select="$require"/>
				</xsl:apply-templates>
			</td>
			<td class="input-block">
				<xsl:apply-templates select="CONTROL[@NAME=$name]" mode="control">
					<xsl:with-param name="require" select="$require"/>
				</xsl:apply-templates>
			</td>
		</tr>
	</xsl:template>
		
</xsl:stylesheet>	