<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:output method="html" indent="yes" encoding="utf-8" doctype-public="-//W3C//DTD HTML 4.0 Transitional//EN"/>
	<xsl:strip-space elements="*"/>

	<xsl:template match="VIEW-CONTENT">
		<xsl:apply-templates select="SB-IMAGE-CONTENT"/>
	</xsl:template>

	<xsl:template match="SITEBUILDER-PAGE">
		<xsl:apply-templates select="VIEW-CONTENT"/>
	</xsl:template>

	<xsl:template match="SB-IMAGE-CONTENT">
		<script type="text/javascript" src="/js/Wizard/Wysiwyg/SbImage.js?{$version}.{$build}"></script>
		<xsl:apply-templates select="@IS-PROVIDERS-BANNERS-ENABLED" mode="SCRIPTS-SOURCES"/>
		<style type="text/css">@import url(/wysiwyg/editor/dialog/common/fck_dialog_common.css?<xsl:value-of select="$version"/>.<xsl:value-of select="$build"/>);</style>
		<table border="0" style="width:100%; height:100%;">
			<tr>
				<td valign="top" style="padding: 0px 5px 5px 5px;">
					<table border="0" style="width:100%; height:100%;">
						<tr id="sbImageProvidersBannersContainerRow">
							<td valign="top" style="width:100%; height: 1px;">
								<div id="sbImageProvidersBannersContainer" style="display: none;">
								</div>
							</td>
						</tr>
						<tr>
							<td valign="top" style="width:100%;">
								<xsl:apply-templates select="TAB-PANEL"/>
							</td>
						</tr>
						<tr>
							<td valign="top" style="padding: 0px 10px 5px 10px;">
								<xsl:call-template name="OK-CANCEL-BUTTONS">
									<xsl:with-param name="okAction">self.parent.sbImageObject.ok();</xsl:with-param>
									<xsl:with-param name="cancelAction">self.parent.sbImageObject.close();</xsl:with-param>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
		<script type="text/javascript" language="javascript">
			InitSbImage();
			<xsl:apply-templates select="@IS-PROVIDERS-BANNERS-ENABLED"/>
		</script>
	</xsl:template>

	<xsl:template match="SB-IMAGE-CONTENT/@IS-PROVIDERS-BANNERS-ENABLED" mode="SCRIPTS-SOURCES">
		<script type="text/javascript" src="/modules/Fotolia/js/banner.js?{$version}.{$build}"></script>
		<script type="text/javascript" src="/modules/Fotolia/js/selectImageFormLoader.js?{$version}.{$build}"></script>
		<script type="text/javascript" src="/modules/Fotolia/js/purchaseImageFormManager.js?{$version}.{$build}"></script>
	</xsl:template>

	<xsl:template match="SB-IMAGE-CONTENT/@IS-PROVIDERS-BANNERS-ENABLED">
		self.parent.sbImageObject.enableImageProvidersBanners();
	</xsl:template>

	<xsl:template match="BROWSE-ONLINE-GALLERY">
		<td style="padding-left: 10px;">
			<xsl:call-template name="BUTTON-CONTROL">
				<xsl:with-param name="title" select="."/>
				<xsl:with-param name="id">fotoliaBrowseGalleryButton</xsl:with-param>
			</xsl:call-template>
		</td>
	</xsl:template>

	<xsl:template match="IMAGE-PROPERTIES">
		<xsl:apply-templates select="CONTROL[@NAME='sbImageSrc']" mode="label">
			<xsl:with-param name="require">true</xsl:with-param>
		</xsl:apply-templates>
		<div style="width: 0; height: 3px;"><span></span></div>
		<table border="0" cellpadding="0" cellspacing="0">
			<tr>
				<td>
					<xsl:apply-templates select="CONTROL[@NAME='sbImageSrc']" mode="control">
						<xsl:with-param name="require">true</xsl:with-param>
						<xsl:with-param name="size">25</xsl:with-param>
					</xsl:apply-templates>
				</td>
				<td style="padding-left: 10px;">
					<xsl:apply-templates select="CONTROL[@NAME = 'sbImageBrowseServer']">
						<xsl:with-param name="action">self.parent.sbImageObject.browseImageServer();</xsl:with-param>
					</xsl:apply-templates>
				</td>
				<xsl:apply-templates select="../../../../BROWSE-ONLINE-GALLERY"/>
			</tr>
		</table>
		<div style="width: 0; height: 5px;"><span></span></div>
		<xsl:apply-templates select="CONTROL[@NAME='sbImageAlt']" mode="label"/>
		<div style="width: 0; height: 3px;"><span></span></div>
		<xsl:apply-templates select="CONTROL[@NAME='sbImageAlt']" mode="control">
			<xsl:with-param name="size">60</xsl:with-param>
		</xsl:apply-templates>
		<div style="width: 0; height: 5px;"><span></span></div>
		<table border="0" cellpadding="0" cellspacing="0" style="width:100%; table-layout: fixed;">
			<tr>
				<td width="40%" valign="top">
					<table cellpadding="0" cellspacing="0" border="0" class="control-title-near-input">
						<tr>
							<td class="title-block"><xsl:apply-templates select="CONTROL[@NAME='sbImageWidth']" mode="label"/></td>
							<td class="input-block">
								<xsl:apply-templates select="CONTROL[@NAME='sbImageWidth']" mode="control">
									<xsl:with-param name="size">10</xsl:with-param>
								</xsl:apply-templates>
							</td>
							<td>
								<div id="sbImageAspectRatioControl"
									class="BtnLocked" onmouseover="self.parent.sbImageObject.onAspectRatioMouseOver();"
									onmouseout="self.parent.sbImageObject.onAspectRatioMouseOut();"
									onclick="self.parent.sbImageObject.switchAspectRatio();">
								</div>
							</td>
						</tr>
						<tr>
							<td class="title-block"><xsl:apply-templates select="CONTROL[@NAME='sbImageHeight']" mode="label"/></td>
							<td class="input-block">
								<xsl:apply-templates select="CONTROL[@NAME='sbImageHeight']" mode="control">
									<xsl:with-param name="size">10</xsl:with-param>
								</xsl:apply-templates>
							</td>
							<td>
								<div id="sbImageResetSizeControl" class="BtnReset"
									onmouseover="this.className='BtnReset BtnOver';"
									onmouseout="this.className='BtnReset';"
									onclick="self.parent.sbImageObject.resetSizes();">
								</div>
							</td>
						</tr>
					</table>
					<table cellpadding="0" cellspacing="0" border="0" class="control-title-near-input">
						<tr>
							<td class="title-block"><xsl:apply-templates select="CONTROL[@NAME='sbImageBorder']" mode="label"/></td>
							<td class="input-block">
								<xsl:apply-templates select="CONTROL[@NAME='sbImageBorder']" mode="control">
									<xsl:with-param name="size">10</xsl:with-param>
								</xsl:apply-templates>
							</td>
						</tr>
						<tr>
							<td class="title-block"><xsl:apply-templates select="CONTROL[@NAME='sbImageHspace']" mode="label"/></td>
							<td class="input-block">
								<xsl:apply-templates select="CONTROL[@NAME='sbImageHspace']" mode="control">
									<xsl:with-param name="size">10</xsl:with-param>
								</xsl:apply-templates>
							</td>
						</tr>
						<tr>
							<td class="title-block"><xsl:apply-templates select="CONTROL[@NAME='sbImageVspace']" mode="label"/></td>
							<td class="input-block">
								<xsl:apply-templates select="CONTROL[@NAME='sbImageVspace']" mode="control">
									<xsl:with-param name="size">10</xsl:with-param>
								</xsl:apply-templates>
							</td>
						</tr>
						<tr>
							<td class="title-block"><xsl:apply-templates select="CONTROL[@NAME='sbImageAlign']" mode="label"/></td>
							<td class="input-block">
								<xsl:apply-templates select="CONTROL[@NAME='sbImageAlign']" mode="control"/>
							</td>
						</tr>
					</table>
				</td>
				<td width="60%" style="padding: 0px 0px 0px 10px;">
					<xsl:value-of select="@IMAGE-PREVIEW-TITLE"/>
					<div class="ImagePreviewArea" style="color: #000000; padding: 10px 10px 10px 10px; width: 90%;">
						<a id="sbImageLinkPreview" onclick="return false;" style="cursor: default;"><img id="sbImagePreview" src="/images/blank.gif" style="display: none;"/></a>Lorem
						ipsum dolor sit amet, consectetuer adipiscing elit. Maecenas feugiat consequat
						diam. Maecenas metus. Vivamus diam purus, cursus a, commodo non, facilisis
						vitae, nulla. Aenean dictum lacinia tortor. Nunc iaculis, nibh non iaculis
						aliquam, orci felis euismod neque, sed ornare massa mauris sed velit. Nulla
						pretium mi et risus. Fusce mi pede, tempor id, cursus ac, ullamcorper nec,
						enim. Sed tortor. Curabitur molestie. Duis velit augue, condimentum at,
						ultrices a, luctus ut, orci. Donec pellentesque egestas eros. Integer cursus,
						augue in cursus faucibus, eros pede bibendum sem, in tempus tellus justo quis
						ligula. Etiam eget tortor. Vestibulum rutrum, est ut placerat elementum, lectus
						nisl aliquam velit, tempor aliquam eros nunc nonummy metus. In eros metus,
						gravida a, gravida sed, lobortis id, turpis. Ut ultrices, ipsum at venenatis
						fringilla, sem nulla lacinia tellus, eget aliquet turpis mauris non enim. Nam
						turpis. Suspendisse lacinia. Curabitur ac tortor ut ipsum egestas elementum.
						Nunc imperdiet gravida mauris.
					</div>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template match="LINK-PROPERTIES">
		<xsl:apply-templates select="CONTROL[@NAME='sbImageLinkUrl']" mode="label"/>
		<div style="width: 0; height: 3px;"><span></span></div>
		<table border="0" cellpadding="0" cellspacing="0">
			<tr>
				<td>
					<xsl:apply-templates select="CONTROL[@NAME='sbImageLinkUrl']" mode="control">
						<xsl:with-param name="size">25</xsl:with-param>
					</xsl:apply-templates>
				</td>
				<td style="padding-left: 10px;">
					<xsl:apply-templates select="CONTROL[@NAME = 'sbImageLinkBrowseServer']">
						<xsl:with-param name="action">self.parent.sbImageObject.browseLinkServer();</xsl:with-param>
					</xsl:apply-templates>
				</td>
			</tr>
		</table>
		<div style="width: 0; height: 5px;"><span></span></div>
		<xsl:apply-templates select="CONTROL[@NAME='sbImageLinkTarget']" mode="label"/>
		<div style="width: 0; height: 3px;"><span></span></div>
		<xsl:apply-templates select="CONTROL[@NAME='sbImageLinkTarget']" mode="control"/>
	</xsl:template>

	<xsl:template match="ADVANCED-PROPERTIES">
		<table cellpadding="0" cellspacing="0" border="0" class="control-title-input">
			<xsl:for-each select="CONTROL">
				<tr>
					<td class="title-block"><xsl:apply-templates select="." mode="label"/></td>
					<td class="input-block">
						<xsl:apply-templates select="." mode="control">
							<xsl:with-param name="size">
								<xsl:choose>
									<xsl:when test="@NAME='sbImageDirection'"></xsl:when>
									<xsl:when test="@NAME='sbImageLanguageCode'">10</xsl:when>
									<xsl:otherwise>60</xsl:otherwise>
								</xsl:choose>
							</xsl:with-param>
						</xsl:apply-templates>
					</td>
				</tr>
			</xsl:for-each>
		</table>
	</xsl:template>

</xsl:stylesheet>